<?php

/**
 * Class that operate on table 'incometype'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-07-19 10:51
 */
class IncometypeMySqlExtDAO extends IncometypeMySqlDAO {

    public function getParents($editid = 0) {
        $sql = 'SELECT * FROM incometype
		WHERE incomeTypeId NOT IN (SELECT incomeTypeId FROM  income)
		AND conditions = 0 and incomeTypeId != ' . $editid;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    //query last expenses types(which not necessarily have a parent) in the hierarcy
    public function queryAllChildrenExt2() {
        $sql = "SELECT DISTINCT(a.incomeTypeId) , a.*
		 FROM incometype a
		 WHERE a.conditions=0
		 AND a.incomeTypeId
         AND a.incomeTypeId NOT IN (
              SELECT parent
			  FROM incometype
			  WHERE conditions = 0
			  AND parent <> 0
           )
		 ORDER BY a.incomeTypeId DESC  ";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    //query all expenses types that have no child types
    public function queryAllChildren() {
        $sql = "SELECT DISTINCT(a.incomeTypeId) , a.*
		 FROM incometype a, incometype b
		 WHERE a.conditions=0
		 AND b.conditions=0
		 AND a.incomeTypeId <> b.parent
		 AND b.parent <> 0
		 ORDER BY a.incomeTypeId DESC ";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllEXNotParent() {
        $sql = 'SELECT incometype.*
                FROM incometype
                left join incometype child on incometype.incomeTypeId = child.parent
                WHERE incometype.conditions = 0
                and child.incomeTypeId is null';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

}

?>